# Google SMS 验证提取器 - 浏览器扩展

## 📂 文件结构

```
extension/
├── manifest.json              # 扩展配置文件
├── qrcode-scanner.js          # 二维码扫描器（自动识别和跳转）
├── super-early-inject.js      # 核心拦截器（MAIN world, document_start）
├── content.js                 # UI 显示（浮动面板）
├── parser.js                  # SMS URI 解析器
├── popup.html                 # 扩展弹窗页面
└── popup.js                   # 弹窗逻辑
```

## 🎯 核心原理

### 1. API 拦截（super-early-inject.js）
- **运行时机**: `document_start`（页面最早期）
- **运行环境**: `MAIN` world（与页面共享 JS 上下文）
- **拦截目标**: Google 的 `batchexecute` API
- **拦截方法**:
  - `fetch` API
  - `XMLHttpRequest`

### 2. 数据提取
API 响应格式：
```javascript
["wrb.fr","MTflnb","[\"96831\",\"Send this message without editing. (ymflETCtiRzo)\"]",...]
```

提取结果：
- 电话号码: `96831`
- 短信内容: `Send this message without editing. (ymflETCtiRzo)`

### 3. 数据传递
```
super-early-inject.js (MAIN world)
    ↓ window.postMessage
content.js (ISOLATED world)
    ↓ 调用 parser.js
显示浮动面板
```

## 🔧 工作流程

```
用户访问 Google 验证页面
    ↓
super-early-inject.js 注入（document_start）
    ↓
覆盖 fetch 和 XMLHttpRequest
    ↓
content.js 显示等待面板（document_idle）
    ↓
用户点击 "Send SMS"
    ↓
拦截 batchexecute API 响应
    ↓
解析 JSON 提取电话号码和短信内容
    ↓
postMessage → content.js
    ↓
解析 SMS URI（parser.js）
    ↓
显示提取结果
```

## 📋 权限说明

```json
{
  "permissions": ["storage"],           // 存储用户设置
  "host_permissions": [                // 仅访问 Google 账号页面
    "https://accounts.google.com/*"
  ]
}
```

## 🚀 使用方法

### 安装
1. 打开 `chrome://extensions/`
2. 启用"开发者模式"
3. 点击"加载已解压的扩展程序"
4. 选择 `extension` 文件夹

### 使用场景 1: 二维码页面
1. 访问 Google 需要验证的页面（显示二维码）
2. 扩展自动检测二维码页面
3. 尝试自动识别二维码中的 URL
4. 如果识别成功，显示跳转提示（3秒后自动跳转）
5. 如果识别失败，可以手动输入 URL

### 使用场景 2: SMS 验证页面
1. 访问 Google 设备验证页面（devicephoneverification）
2. 扩展显示等待面板
3. 点击 "Send SMS" 按钮
4. 自动提取并显示验证信息（电话号码 + 短信内容）
5. 点击"复制令牌"一键复制

## 💡 技术亮点

1. **零服务器成本** - 完全在客户端运行
2. **保护隐私** - 数据不上传
3. **高效拦截** - 在 API 层面拦截，不依赖 DOM
4. **跨平台** - 支持 Chrome、Edge 等 Chromium 内核浏览器
5. **代码精简** - 核心代码仅 3 个文件，总计不到 15KB

## 🔐 安全性

- ✅ 只在 Google 账号页面激活
- ✅ 不访问其他网站
- ✅ 不上传任何数据
- ✅ 开源代码，可审计
- ✅ 符合 Chrome Web Store 政策

## 📝 版本历史

- **v1.1.0** (2024-11-22)
  - 新增二维码页面自动识别功能
  - 支持自动跳转到验证页面
  - 提供手动输入 URL 的备选方案
  - 优化用户体验

- **v1.0.0** (2024-11-21)
  - 首次发布
  - 支持提取 Google 设备验证 SMS 信息
  - 拦截 batchexecute API
  - 浮动面板显示

