/**
 * Google SMS 验证提取器 - Popup 脚本
 * @version 1.0.0
 */

document.addEventListener('DOMContentLoaded', function() {
  loadData();
  setupEventListeners();
});

// 加载数据
function loadData() {
  chrome.storage.local.get(['lastResult', 'timestamp'], function(data) {
    if (data.lastResult && data.lastResult.success) {
      displayResult(data.lastResult, data.timestamp);
    }
  });
}

// 显示结果
function displayResult(result, timestamp) {
  document.getElementById('no-data').style.display = 'none';
  document.getElementById('result-view').style.display = 'block';

  document.getElementById('phone-value').textContent = result.phoneNumber || 'N/A';
  document.getElementById('body-value').textContent = result.smsBody || 'N/A';
  document.getElementById('token-value').textContent = result.verificationToken || 'N/A';

  if (timestamp) {
    const date = new Date(timestamp);
    document.getElementById('time-value').textContent =
      `提取时间: ${date.toLocaleString('zh-CN')}`;
  }
}

// 设置事件监听
function setupEventListeners() {
  // 复制按钮
  document.querySelectorAll('.copy-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      const targetId = this.getAttribute('data-target');
      const element = document.getElementById(targetId);
      const text = element.textContent;

      copyToClipboard(text, this);
    });
  });

  // 清除按钮
  document.getElementById('clear-btn').addEventListener('click', function() {
    if (confirm('确定要清除数据吗？')) {
      chrome.storage.local.remove(['lastResult', 'timestamp'], function() {
        location.reload();
      });
    }
  });

  // 帮助按钮
  document.getElementById('help-btn').addEventListener('click', function() {
    chrome.tabs.create({
      url: 'https://github.com/yourusername/sms-extractor'
    });
  });
}

// 复制到剪贴板
function copyToClipboard(text, button) {
  navigator.clipboard.writeText(text).then(() => {
    const original = button.textContent;
    button.textContent = '✓ 已复制';
    button.classList.add('success');

    setTimeout(() => {
      button.textContent = original;
      button.classList.remove('success');
    }, 2000);
  }).catch(err => {
    console.error('复制失败:', err);
    alert('复制失败，请手动复制');
  });
}

